import { Popover, TYIcon } from '@tingwujs/design';
import React, { useMemo, useRef } from 'react';

import './PlayerOpts.less';

interface iPlayerOptsProps {
  children?: React.ReactNode;
  isLoading?: boolean;
}

// 播放器面板选项
const PlayerOpts: React.FC<iPlayerOptsProps> = (props: any) => {
  const { children, isLoading = false } = props;
  const iconWrapper = useRef<HTMLDivElement>(null);

  const renderPlayerOptsContent = useMemo(() => {
    return <div className="PlayerOpts-Content">{children}</div>;
  }, [children]);

  if (isLoading) {
    return (
      <div ref={iconWrapper} style={{ marginLeft: '10px', lineHeight: '10px' }}>
        <TYIcon
          className={`icon control_icon ${isLoading && 'docAudioloading'}`}
          style={{ fontSize: '20px' }}
          type="spark-config-line"
        />
      </div>
    );
  }

  return (
    <Popover
      className="PlayerOpts"
      title={null}
      content={renderPlayerOptsContent}
      overlayInnerStyle={{ padding: 0 }}
      getPopupContainer={() => iconWrapper.current as any}
    >
      <div ref={iconWrapper} style={{ marginLeft: '10px', lineHeight: '10px' }}>
        <TYIcon
          className={`icon control_icon ${isLoading && 'docAudioloading'}`}
          style={{ fontSize: '20px' }}
          type="spark-config-line"
        />
      </div>
    </Popover>
  );
};

const memoPlayerOpts = React.memo(PlayerOpts);
export { memoPlayerOpts as PlayerOpts };
