import { AgendaSummaryBean } from '../../WuLab/Agenda/agendaBean';

export type markType = 'point' | 'segment';

export interface MarkSegParams {
  startTime: number;
  endTime: number;
  text: string;
  color?: string;
}

export interface MarkSegResult extends MarkSegParams {
  leftValue: string;
  widthValue: string;
}

export interface TimeTooltipContent {
  time: string;
  text?: string;
  offsetX: number;
  rectWidth: number;
  agendaSummary?: AgendaSummaryBean;
  dotVisible?: boolean;
  audioRight?: number;
  audioLeft?: number;
  minLeft?: number;
}

export interface TimeTooltipPosition {
  left: number;
  top?: number;
}

export interface ControlParams {
  audioRateList: number[];
  markPointList?: any;
  markSegmentList?: MarkSegParams[];
  spectrum: number[];
  jumpTipsTime?: string;
}

export interface MarkPointParams {
  startTime: number;
  text: string;
  color?: string;
}
