import React, { useEffect, useRef, useState } from 'react';
import styled from 'styled-components';

import { TipsAgendaContext } from '../../../WuLab/Agenda/TipsAgenda';
import { TimeTooltipContent, TimeTooltipPosition } from '../control';

const MyToolTips = styled.div`
  position: relative;
  .line {
    position: absolute;
    top: -13px;
    left: 0px;
    z-index: 5;
    width: 2px;
    min-height: 22px;
    background: #615ced;
    border-radius: 1px;
    pointer-events: none;
  }
`;

const audioLeft = 258;
const audioTipRight = 2;

const TimeToolTip: React.FC<TimeTooltipContent | {}> = (
  props: TimeTooltipContent | {},
) => {
  const { time, text, offsetX, rectWidth, agendaSummary, minLeft } =
    props as TimeTooltipContent;

  const timeTooltipRef = useRef<HTMLDivElement>(null);
  const [timeTooltipPos, setTimeTooltipPos] = useState<
    TimeTooltipPosition | {}
  >({});

  useEffect(() => {
    if (offsetX === undefined || rectWidth === undefined) return;
    if (!timeTooltipRef?.current) return;

    const dom = timeTooltipRef.current;
    const { width } = dom.getBoundingClientRect();
    let left = offsetX - width / 2;
    const bodyWidth = document.body.clientWidth;

    if (text && agendaSummary) {
      if (bodyWidth - (left + audioLeft) < width + audioTipRight) {
        left = bodyWidth - width - audioTipRight - audioLeft;
      }
    }

    // left =
    //   left + width > (rectWidth as number) - 4
    //     ? (rectWidth as number) - 4 - width
    //     : left;
    if (minLeft && left < minLeft) {
      left = minLeft;
    }
    setTimeTooltipPos({
      left,
    });
  }, [offsetX, text, timeTooltipRef?.current]);

  const tipsLeft = (timeTooltipPos as TimeTooltipPosition)?.left || 0;
  const lineLeft = offsetX - 1 || 0;

  // 章节速览hover tips 有摘要
  if (offsetX !== undefined && text && agendaSummary) {
    return (
      <MyToolTips>
        <div
          ref={timeTooltipRef}
          style={{
            position: 'absolute',
            bottom: 22,
            zIndex: 800,
            backgroundImage: `url(https://img.alicdn.com/imgextra/i2/O1CN01Ct5IPl1bwKoOc5C1f_!!6000000003529-2-tps-459-108.png)`,
            backgroundPosition: 'top left',
            backgroundSize: 'cover',
            backgroundRepeat: 'no-repeat',
            width: 459,
            left: tipsLeft,
            borderRadius: 8,
          }}
        >
          <TipsAgendaContext
            style={{ opacity: 0 }}
            info={agendaSummary}
            time={time}
            maxHeight={document.body.clientHeight * 0.8}
          />

          <img
            src={
              'https://img.alicdn.com/imgextra/i4/O1CN01xZIcIy1tguYfF0FtC_!!6000000005932-2-tps-260-55.png'
            }
            style={{
              position: 'absolute',
              bottom: -7,
              left: lineLeft - tipsLeft - 129, // 129是 triangle.png的宽度的一半，替换图片时候，需要注意修改这个值
            }}
          />

          <TipsAgendaContext
            style={{ position: 'absolute', top: 0, left: 0 }}
            info={agendaSummary}
            time={time}
            maxHeight={document.body.clientHeight * 0.8}
          />
        </div>
        <div
          style={{
            left: lineLeft,
          }}
          className="line"
        />
      </MyToolTips>
    );
  }

  // 章节速览hover tips 无摘要
  if (offsetX !== undefined && text && !agendaSummary) {
    return (
      <MyToolTips>
        <div
          className="timeTooltipBox"
          ref={timeTooltipRef}
          style={{
            left: `${(timeTooltipPos as TimeTooltipPosition)?.left || 0}px`,
          }}
        >
          <div className="arrow" />
          <div className={`textBox`}>
            {!text && (
              <div
                className="timeBox"
                style={{
                  color: 'rgba(255, 255, 255,.6)',
                  transform: 'scale(0.8)',
                  transformOrigin: '0 0',
                }}
              >
                {time}
              </div>
            )}
            <div className="highlightText">
              {text?.length > 15 ? `${text.slice(0, 15)}...` : text || ''}
            </div>
          </div>
        </div>
        <div
          style={{
            left: offsetX - 1,
          }}
          className="line"
        />
      </MyToolTips>
    );
  }

  // 时间 tips
  if (offsetX !== undefined && !text) {
    return (
      <MyToolTips>
        <div
          className="timeTooltipBox"
          ref={timeTooltipRef}
          style={{
            left: tipsLeft,
          }}
        >
          <div className="arrow" />
          <div className={`textBox`}>
            <div
              className="timeBox"
              style={{
                color: 'rgba(255, 255, 255)',
              }}
            >
              {time}
            </div>
          </div>
        </div>
        <div
          style={{
            left: lineLeft,
          }}
          className="line"
        />
      </MyToolTips>
    );
  }
  return null;
};

export default TimeToolTip;
