import { Paragraph, UID } from '@tingwujs/core';
import { AgendaSummaryBean } from '../../WuLab/Agenda/types/AgendaBean';

interface CommonUseSpeaker {
  uid: UID;
  name: string;
  avatarUrl?: string;
  bizUid?: string;
  nameAvaId?: number;
}
interface ChangeInfo {
  addParagraphPids: string[];
  removeParagraphPids: string[];
  updateParagraphPids: string[];
  removeParagraphs?: Record<string, Paragraph> | undefined;
}

interface ParagraphsProps {
  onLoad?: () => void;
}
interface MarkProps {
  startTime: number;
  endTime: number;
  color: string;
  text: string;
}

interface rateSummaryAppraiseInfoType {
  star: number;
  summary: AgendaSummaryBean;
}

interface Speaker {
  uid: UID;
  name: string;
  avatarUrl?: string;
  bizUid?: string;
  nameAvaId?: number;
}

export enum Tabs {
  Intro = 'intro',
  Wulabs = 'wulabs',
  Paragraphs = 'paragraphs',
}

export {
  ParagraphsProps,
  CommonUseSpeaker,
  ChangeInfo,
  rateSummaryAppraiseInfoType,
  Speaker,
  MarkProps,
};
