import { Fragment, memo, useRef } from 'react';

/** 新数据 引用 */
import { docBaseHooks, docPlayerHooks } from '../../../../../../documentModel';
import { iTransResultData } from '../../../../../../documentModel/docBase/docBase.type';

import { usePlayerProgressRecordEffect } from '../../../../../../pages/docASR/components/businessCommon/separateHooks';
import { DocAudioPlayer } from '../../../businessCommon/DocMediaPlayer';

import Paragraphs from '../../Paragraphs';

import { setCommonData } from '../../../businessCommon/constVariable';

import { IProps } from '../../../../pageDetail/pageEdit/types/props';
import { EditorContentContainer } from './style';

const LeftContent = memo((props: IProps) => {
  const { docBaseData = {} } = docBaseHooks.useDocBaseData();
  const { docPlayerData } = docPlayerHooks.useDocPlayerData();
  const { isVideo } = (docBaseData as iTransResultData) || {};

  /** 初始定义一些变量 */

  const { loading } = props;

  /** 设置一些公共数据, 供其他组件使用 */
  setCommonData('loading', loading);

  /** 监听文档播放器历史播放进度 & 提示 */
  usePlayerProgressRecordEffect();

  // 页面滚动容器
  const pageScrollWrapperRef = useRef<HTMLDivElement>(null);
  return (
    <Fragment>
      <EditorContentContainer>
        <div
          id="editorContentBottom"
          ref={pageScrollWrapperRef}
          className="editorContentBottom"
          style={{
            height:
              !(!isVideo || docPlayerData?.playerMode === 'audio') ||
              !docPlayerData?.audioUrl
                ? `calc(100% - ${0}px - 52px)`
                : `calc(100% - ${0}px - 97px - 52px)`,
            paddingRight: 0,
          }}
        >
          <div
            className="editorContentBottomLeft"
            id="editorContentBottomLeft"
            ref={pageScrollWrapperRef}
          >
            {/** 章节速览&关键词&段落 */}
            <div
              className="editorContentBottomLeftContent"
              id="tingwu2_editorContentBottomLeftContent" // 不要删掉有用处
              style={{ paddingBottom: 10 }}
            >
              <Paragraphs />
            </div>
          </div>
        </div>
        {/* 音频播放器 */}
        {docPlayerData?.playerMode === 'audio' && (
          <DocAudioPlayer playerWrapperRef={pageScrollWrapperRef} />
        )}
      </EditorContentContainer>
    </Fragment>
  );
});

export default LeftContent;
