import { Loading } from './components/BaseCompontents/Loading';
import { useEffect, useMemo, useState } from 'react';

const PageLoading = () => {
  const [isDelayLoading, setIsDelayLoading] = useState(true);

  useEffect(() => {
    const timer = setTimeout(() => {
      setIsDelayLoading(false);
    }, 300);

    return () => clearTimeout(timer);
  }, []);

  const content = useMemo(() => {
    if (isDelayLoading)
      return (
        <div
          style={{
            width: '100%',
            height: '100%',
            background: '#f4f7fc',
          }}
        />
      );

    return <Loading />;
  }, [isDelayLoading]);

  return content;
};

export default PageLoading;
