/** 保存到 Tag 的发言人数据 */
// 发言人 tag 对照数据
export interface iDocApiSpeaker {
  ui: string; // 发言人 ID
  name: string; // 发言人名称
  nameAvaId?: number; // 发言人编辑后的头像 ID
  isNewSpeakerSummer?: boolean; // 是否只有发言总结处有的发言人数据
  defaultAvatarIdx?: number; // 默认发言人头像ID
}
// 发言人接口数据
export interface iDocSpeakerAPIData {
  /** 外网发言人 */
  // 用户信息对照表 <nameId, speakerInfo>
  user_info: Record<string, iDocApiSpeaker>;
  // 用户 ID 对照表 <ui(原文段落ui), nameId(修改后的姓名ID)>
  user_map_info: Record<string, string>;
}
