import {
  eDocFileType,
  eDocScene,
  eDocShareError,
  iDocIDType,
} from './document.baseType';

import { iDocBaseDataMap } from './docBase/docBase.type';
import { iDocBigModelDataMap } from './docBigModel/docBigModel.type';
import { iDocPlayerDataMap } from './docPlayer/docPlayer.types';
import { iDocRouteData } from './docRoute/docRoute.type';
import { iDocSpeakerDataMap } from './docSpeaker/docSpeaker.type';
import { iDocTagDataMap } from './docTag/docTag.type';
import { iDocTextPolishMap } from './docTextPolish/docTextPolish.type';
import { iDocTranslateDataMap } from './docTranslate/docTranslate.type';
// 文档数据模型
export interface iDocumentState {
  namespace: string; // 命名空间
  /** 基础公用数据 */
  docId?: iDocIDType; // 文档 ID(纪要 ID | 内容盒子 ID)
  docScene?: eDocScene; // 文档场景: 纪要/纪要分享/内容盒子/内容盒子分享/未知
  docFileType?: eDocFileType; // 转写文件类型
  docErrorCode?: eDocShareError; // 文档错误码
  /** 细分数据模型 Map<docId, data> 结构 */
  docRouteData: iDocRouteData; // 路由层数据 DONE
  docBaseDataMap: iDocBaseDataMap; // 基础内容内容 PARTIAL
  docTagDataMap: iDocTagDataMap; // tag 状态只在数据层引用，不提供 hooks 对外使用 PARTIAL
  docSpeakerDataMap: iDocSpeakerDataMap; // 文档发言人数据 PARTIAL
  docBigModelDataMap: iDocBigModelDataMap; // 文档大模型数据 PARTIAL
  docTranslateDataMap: iDocTranslateDataMap; // 文档翻译数据 PARTIAL
  docPlayerDataMap: iDocPlayerDataMap; // 播放器相关状态数据
  docTextPolishMap: iDocTextPolishMap; // AI改写数据
}

// 👇🏻 Uncertainty
/** 一、细分数据模型 */
/** 二、状态数据模型 */
// 文档相关状态
export interface iDocDataState {}
// 各种 tag 数据模型
export interface iDocTagState {
  // 播放器状态相关
  mediaTag?: {
    skipBlank: boolean; // 跳过空白帧
    subtitle: boolean; // 字幕
    subtitleSpeaker: boolean; // 字幕-发言人
  };
}

// document 模型
export interface iDocumentModel {
  namespace: string;
  state: iDocumentState;
  effects: {};
  reducers: {};
}
