// 基础类型
export const documentModelNS = 'documentModel'; // 命名空间
export const namespacePrefix = (path: string, isHookUse = false) => {
  if (!isHookUse) return path;
  return `${documentModelNS}/${path}`;
};
export interface Action<T = undefined> {
  type: symbol | string;
  payload: T;
}

// 文档 ID 类型
export type iDocIDType = string | number;

// 数据更新基础 Payload 类型
export interface iDocDataUpdateBasePayload<T = undefined> {
  docId: iDocIDType;
  docScene: eDocScene;
  data?: T;
}

// 文档类型
export enum eDocScene {
  trans = 'trans', // 转写
  discovery = 'discovery', // 内容盒子 【弹窗详情】
  transShare = 'trans-share', // 转写 分享
  discoveryShare = 'discoveryShare', // 内容盒子 分享
  oldShare = 'oldShare', // 旧存 分享详情
  unknown = '', // 未知类型(暂未用到)
}

// 转写文件来源类型
export enum eDocFileType {
  local = 'local', // 本地上传
  meeting = 'meeting', // 实时记录
  aliyun_drive = 'aliyun_drive', // 阿里云盘
  net_source = 'net_source', // 播客链接转写
  explore_save = 'explore_save', // 内容盒子保存
  chrome_extension = 'chrome_extension', // 浏览器插件
  mars = 'mars', // 暂未用到
  mars_meeting = 'mars_meeting', // 暂未用到
  transcript = 'transcript', // 创建副本
}

// 转写语言配置
export enum eTranscriptionLanguage {
  cn = 'cn', // 中文
  en = 'en', // 英语
  ja = 'ja', // 日语
  yue = 'yue', // 粤语
  fspk = 'fspk', // 中英文自由说
}

// 转写语言翻译相关配置:1中文 2英语 3粤语 4中英文自由说 5日语
export enum eTransLangTranslateMap {
  off = 0, // 0 关闭翻译
  cn = 1, // 中文
  en = 2, // 英文
  yue = 3, // 粤语
  fspk = 4, // 中英文自由说
  ja = 5, // 日语
}

// 翻译展示状态: 2 双语; 1 纯译文(默认双语展示)
export enum eDocTranslateDisplayMode {
  Bilingual = 2, // 双语
  translation = 1, // 纯译文
}

// 转写文件媒体类型
export enum eTransMediaType {
  audio = 'audio', // 图片
  video = 'video', // 视频
  file = 'file', // 视频
}

// 视频清晰度
export enum eVideoQuality {
  HD = 'HD',
  SD = 'SD',
  LD = 'LD',
  FDH = 'FDH',
  QHD = 'QHD',
}

// 分享错误码
export enum eDocShareError {
  // doc
  InvalidTrans = 'TRS.InvalidTrans', // 记录无效（不存在或已经被删除）
  InvalidTransUser = 'TRS.InvalidTransUser', // 查询的纪要不属于当前用户
  TrashTrans = 'TRS.TrashTrans',
  // share
  InvalidRequest = 'SHA.InvalidRequest', // 取消分享，分享链接无效
  ShareClosed = 'SHA.ShareClosed', // 分享已关闭
  NeedLogin = 'TRS.NeedLogin', // 需要登录
}

// 接口调用结果
export enum eAPIStatus {
  FAIL = -1, // 失败
  SUCCESS = 0, // 成功
  LOADING = 2, // 加载中
  PARTIAL = 3, // 部分成功
  DONE = 4, // 已完成
  CANCEL = 5, // 已取消
  UNKNOWN = 6, // 未知状态
}

// 分享翻译状态
export enum eShareTranslateStatus {
  TRANSLATING = 'translating', // 代表翻译进行中 超时时间30s
  COMPLETED = 'completed', // 代表翻译成功完成或翻译部分完成 总之是有结果
  FAILED = 'failed', // 代表翻译调用失败 对于Lab则是所有Lab结果都翻译失败
  NOTRANSLATE = 'notranslate', // 代表传入的id没有调用过翻译 应该先调用翻译
}
