import { iDocumentState } from '../../document.type';

import * as docTranslateActions from './docTranslate.actions';

// DocTranslate Reducers
export const docTranslateReducers = {
  // 更新翻译数据
  updateDocTranslateDataReducer(
    state: iDocumentState,
    action: ReturnType<typeof docTranslateActions.updateDocTranslateDataAction>,
  ) {
    const { docId, data } = action.payload;
    const docTranslateData = data!;
    // 更新翻译数据
    const _docTranslateData = { [docId]: docTranslateData };
    return {
      ...state,
      ...{
        docTranslateDataMap: {
          ...state.docTranslateDataMap,
          ..._docTranslateData,
        },
      },
    };
  },
  // 部分翻译数据更新
  updateDocTranslatePartialDataReducer(
    state: iDocumentState,
    action: ReturnType<
      typeof docTranslateActions.updateDocTranslatePartialDataAction
    >,
  ) {
    const { docId, data } = action.payload;
    const partialDocTranslateData = data!;
    // 更新翻译数据
    Object.keys(partialDocTranslateData).forEach((key) => {
      state.docTranslateDataMap[docId][key] = partialDocTranslateData[key];
    });
    return state;
  },
};
