import { eTransLangTranslateMap } from '../../../documentModel/document.baseType';
import { iDocTranslateData } from '../docTranslate.type';

// 原文翻译内容处理
export const originApiTranslateToLocalTransfer = (translateDoc: any): any => {
  try {
    if (
      translateDoc &&
      translateDoc.paragraphs &&
      translateDoc.paragraphs.length > 0
    ) {
      const transData = translateDoc.paragraphs.map((item) => {
        return {
          pi: item.paragraphId,
          ts: item.sentences?.map((_item) => ({
            bt: _item.start,
            et: _item.end,
            si: _item.sentenceId,
            txt: _item.text,
          })),
        };
      });
      return { pg: transData };
    }

    return {};

    // return translatePg?.map((item: any) => {
    //   const value = item.ts.map((_item: any) => {
    //     const _value: any = { ..._item };
    //     _value.tc = _item.txt;
    //     delete _value.txt;
    //     return _value;
    //   });
    //   return value;
    // });
  } catch (e) {
    console.error('originApiTranslateToLocalTransfer error', e);
    return null;
  }
};

// 分享页面的数据标签补全
export const translationLangToLocalTransfer = ({
  translationLang, // 翻译使用标记
  translateTargetLanguage, // 翻译目标语言
  translateDisplayMode, // 翻译显示模式
}: iDocTranslateData) => {
  const formatValue: iDocTranslateData = {};
  if (translationLang) {
    formatValue.translationLang = translationLang;
    const [targetLang, mode] = translationLang.split('_');
    const undefinedTargetLang = mode === undefined;
    formatValue.translateTargetLanguage = undefinedTargetLang
      ? undefined
      : Number(
          Object.entries(eTransLangTranslateMap).filter(([key]) => {
            return key === targetLang;
          })[0][1],
        );
    formatValue.translateDisplayMode = Number(
      undefinedTargetLang ? targetLang : mode,
    );
  } else {
    formatValue.translateTargetLanguage = translateTargetLanguage;
    formatValue.translateDisplayMode = translateDisplayMode;
    const undefinedTargetLang = translateTargetLanguage === undefined;
    formatValue.translationLang = undefinedTargetLang
      ? `${translateDisplayMode}`
      : `${
          Object.entries(eTransLangTranslateMap).filter(([key]) => {
            return key === String(translateTargetLanguage);
          })[0][1]
        }_${translateDisplayMode}`;
  }
  return formatValue;
};

// 大模型数据处理(针对成功数据)
export const getBigModelTranslationToLocalTransfer = (
  allLabTranslates: any[],
) => {
  return allLabTranslates.reduce((pre, lab: any) => {
    const { showKey, contentValues } = lab;
    pre[showKey] = contentValues;
    return pre;
  }, {});
};
