import { iDocumentState } from '../../document.type';

import * as docTranslateActions from './docTextPolish.actions';

// DocTextPolish Reducers
export const docTextPolishReducers = {
  // 更新AI原文改写数据
  updateDocTextPolishDataReducer(
    state: iDocumentState,
    action: ReturnType<
      typeof docTranslateActions.updateDocTextPolishDataAction
    >,
  ) {
    const { docId, data } = action.payload;
    const docTextPolishData = data!;
    // 更新翻译数据

    const _docTextPolishData = { [docId]: docTextPolishData };
    return {
      ...state,
      ...{
        docTextPolishMap: { ...state.docTextPolishMap, ..._docTextPolishData },
      },
    };
  },
  // 更新部分AI原文改写数据
  updateDocTextPolishPartialDataReducer(
    state: iDocumentState,
    action: ReturnType<
      typeof docTranslateActions.updateDocTextPolishPartialDataAction
    >,
  ) {
    const { docId, data } = action.payload;
    const docTextPolishData = data!;
    // 更新翻译数据
    Object.keys(docTextPolishData).forEach((key) => {
      state.docTextPolishMap[docId][key] = docTextPolishData[key];
    });
    return state;
  },
};
