import {
  documentModelNS,
  iDocDataUpdateBasePayload,
} from '../../document.baseType';
import { iDocTextPolishData } from '../docTextPolish.type';

/** Reducer Actions */

// 整体翻译数据更新
export const updateDocTextPolishDataAction = (
  payload: iDocDataUpdateBasePayload<iDocTextPolishData>,
) => ({
  type: 'updateDocTextPolishDataReducer',
  payload,
});
// 更新部分翻译内容
export const updateDocTextPolishPartialDataAction = (
  payload: iDocDataUpdateBasePayload<Partial<iDocTextPolishData>>,
) => ({
  type: 'updateDocTextPolishPartialDataReducer',
  payload,
});

/**
 * @description: 初始化AI原文改写数据
 */
export const initDocTextPolishDataAction = (
  payload: iDocDataUpdateBasePayload<null>,
) => ({
  type: 'initDocTextPolishDataEffect',
  payload,
});

// 更改AI改写是否开启
export const changeTextPolishSwitchAction = (payload: any) => ({
  type: `documentModel/changeTextPolishSwitchEffect`,
  payload,
});
