import { useMemo } from 'react';
import { useSelector } from 'react-redux';

import { iDocumentState } from '../document.type';

// DocTextPolish Hooks
const useDocTextPolishData = () => {
  // redux 取数
  const { docId, docTextPolishMap } = useSelector(
    (state: { documentModel: iDocumentState }) => ({
      docId: state.documentModel.docId!,
      docScene: state.documentModel.docScene!,
      docTextPolishMap: state.documentModel.docTextPolishMap,
    }),
  );

  // 当前文档的AI改写数据
  const docTextPolishData = useMemo(() => {
    if (!docId || !docTextPolishMap) return undefined;
    return docTextPolishMap[docId];
  }, [docId, docTextPolishMap]);

  return {
    docTextPolishData,
  };
};

export { useDocTextPolishData };
