import { eDocSpeakerSplitStatus, iDocTagData } from '../docTag.type';

// 获取默认数据
export const getDefaultDocTagData = () => {
  // const defaultDocTagData: iDocTagData = {
  const defaultDocTagData: any = {
    initDotReady: false, // 离线小红点：wulab总按钮，全文概要，章节速览
    read: 1, // 是否已读
    // 媒体相关 Tag
    mediaTag: {
      skipBlank: false, // 是否跳过空白片段
      subtitle: false, // 是否显示字幕
      subtitleSpeaker: false, // 是否显示字幕发言人
    },
    // 翻译相关 Tag
    translateLoading: 0, // 翻译是否加载中
    translateLanguageConf: 0, // 翻译显示配置
    translateSwitch: 0, // 翻译是否开启
    originLanguageValue: 0, // 翻译源语言
    transTargetValue: 0, // 翻译目标语言
    // 发言人相关 Tag
    roleSplitTip: eDocSpeakerSplitStatus.close, // 发言人开启状态
    roleSplitNum: -1, // 发言人开启状态
    // QA 问答相关 Tag
    QASwitchStatus: 0, // QA 问答是否开启
    // 新手引导相关
    pptDotVisible: 0,
    pptMessageVisible: 0,
    // TODO: 待确认
    shareQASwitchStatus: 0,
    audioStatus: 1,
  };

  return defaultDocTagData;
};

// DocTag API 数据转为内部状态
export const apiDocTagToLocalTransfer = (data: iDocTagData) => {
  try {
    console.log('data', data);
  } catch (e) {
    console.error('docTag 处理失败', e);
  }
  return data;
};
// DocTag 转为API 数据
export const localDocTagToApiTransfer = (data: Partial<iDocTagData>) => {
  const transferredDocData: Record<string, string> = {};
  Object.keys(data).forEach((key) => {
    transferredDocData[key] =
      typeof data[key] === 'string' ? data[key] : JSON.stringify(data[key]);
  });
  return transferredDocData;
};
