// 接口发言人对照数据
export interface iDocApiSpeaker {
  ui: string; // 发言人 ID
  name: string; // 发言人名称
  nameAvaId?: number; // 发言人编辑后的头像 ID
  isNewSpeakerSummer?: boolean; // 是否只有发言总结处有的发言人数据
  defaultAvatarIdx?: number; // 默认发言人头像ID
  // 集团发言人(名称、头像、工号)
  uid?: string;
  avatarUrl?: string;
  bizUid?: string;
  userid?: string; // 发言人工号
}

// 内部发言人数据(继承原始发言人数据：作为数据对照)
export interface iDocSpeaker extends iDocApiSpeaker {
  uid: string; // 发言人id; 对照 MAP:ui
  userMapInfoId?: string; // 用户信息表id
  displayName: string; // 发言人显示名称
  speakerAvatar: string; // 发言人头像
  speakerAvatarName: string; // 发言人头像显示文字
  speakerAvatarBgColor?: string; // 已修改发言人头像背景色
  inSpeakerSummer?: boolean; // 是否只有发言总结处有的发言人数据
  isUnknownUser?: boolean; // 是否未知发言人
  // 其他渲染信息
  isSpeaking?: boolean; // 当前用户是否正在发言
  isHighlight?: boolean; // 是否高亮的用户
}

// DocSpeaker 类型
export interface iDocSpeakerData {
  /** 发言人区分 */
  speakersSplitIsOpen: boolean; // 发言人区分是否开启
  speakersSplitIsLoading: boolean; // 发言人区分是否加载中
  speakersSplitType?: number; // 发言人区分类型, -1:不体验, 0:多人, 1:单人,2:2人,3:默认值
  /** 发言人数据 */
  // 发言人头像最后序号(1-9)
  speakerAvatarLength: number; // 发言人头像长度
  speakerAvatarLastIndex?: number; // 当前已使用的发言人头像下标
  // 发言人列表
  speakersData: iDocSpeaker[];
  // 发言人 identify，用作数据对比
  speakerUserInfoMap?: iDocSpeakerAPIData;
}

// 发言人接口数据
export interface iDocSpeakerAPIData {
  system_user_info: {};
  /** 外网发言人 */
  // 用户信息对照表
  user_info: Record<string, iDocApiSpeaker>;
  // 用户 ID 对照表
  user_map_info: Record<string, string>;
}

// DocSpeaker 存储类型
export type iDocSpeakerDataMap = Record<string, iDocSpeakerData>;
