import qs from 'query-string';
import { eDocScene } from '../../document.baseType';

// 获取路由场景
export const getRouteSceneService = () => {
  const { pathname } = window.location;
  if (pathname.includes('/details/')) {
    return eDocScene.trans;
  }
  return eDocScene.unknown;
};

// 从路由获取 docId
export const getRouteDocIdService = () => {
  const { pathname } = window.location;
  return pathname.split('/details/')?.[1];
};

// 获取路由完整路径
export const getRouteFullPathService = () => {
  const url = new URL(window.location.href);
  return url.href.split(url.origin)[1];
};

// 解析路由参数
export const getRouteSearchParamsService = () => {
  const url = new URL(window.location.href);
  return qs.parse(url.search);
};
