import { eDocScene } from '../../document.baseType';
import { documentActions } from '../../document.operator';

import { iDocRouteData } from '../docRoute.type';
import * as docRouteActions from './docRoute.actions';
import * as docRouteServices from './docRoute.services';

// DocRoute Effects
export const docRouteEffects = {
  // 初始化路由数据
  *initRouteDataEffect(_action: ReturnType<any>, { put }) {
    // 区分路由场景，场景不识别就返回
    const routeScene = docRouteServices.getRouteSceneService();
    if (routeScene === eDocScene.unknown) {
      return { routeScene };
    }

    // 其他参数
    const routeDocId = docRouteServices.getRouteDocIdService();
    const routeFullPath = docRouteServices.getRouteFullPathService();
    const routeParams = docRouteServices.getRouteSearchParamsService();

    // 组合数据
    const docRouteData: iDocRouteData = {
      routeScene,
      routeDocId,
      routeFullPath,
      routeParams,
    };

    // 更新 Redux 数据
    yield put(docRouteActions.updateRouteDataAction(docRouteData)); // DocRoute
    yield put(
      documentActions.updateDocumentCurtDataAction({
        docId: docRouteData.routeDocId,
        docScene: docRouteData.routeScene,
        forceUpdate: true,
      }),
    ); // Document
    return docRouteData;
  },
};
