import { eSyncingMediaStatus } from '../docTag/docTag.type';
import { iDocIDType } from '../document.baseType';

// 播放器相关状态数据
export interface iDocPlayerData {
  playerMode: 'video' | 'audio'; // 播放器模式
  // 播放器基础状态
  playerCurtTime: number; // 当前播放时间(音频、视频都是毫秒ms)
  playerIsPlaying: boolean; // 播放器是否在正在播放
  playerMuted: boolean; // 播放器是否静音
  playerVolume: number; // 播放器是否显示音量
  playerRate: number; // 播放速率
  // 播放器状态记录
  showSubtitle: boolean; // 是否显示字幕
  showSubtitleSpeaker: boolean; // 显示字幕发言人
  skipBlankSegment: boolean; // 是否跳过空白片段
  playerRecordTime: number; // 记录的播放进度时间
  playerRecordTimeTipOpen: boolean; // 记录播放进度提示是否打开
  playerSyncMediaStatus?: eSyncingMediaStatus; // 服务端同步视频状态: 1副本创建中 3副本创建失败
  // 播放链接数据
  videoUrl: string; // 视频播放地址
  videoPoster: string; // 视频海报地址
  audioUrl: string; // 音频播放地址
  audioSegments: number[][]; // 音频分段数据(跳过空白片段用)
  audioSpectrum: number[]; // 音频频谱数据
  docIsVideo: boolean; // 当前文件是否为视频
  // 其他样式属性
  videoPlayerHeight: number; // 播放器高度
  videoPlayerWidth: number; // 播放器宽度
  subtitlesModel: 'dark' | 'light';
}

// 获取播放器默认数据
export const getDefaultDocPlayerData = (): iDocPlayerData =>
  ({
    playerCurtTime: 0,
    playerIsPlaying: false,
    playerMuted: false,
    playerVolume: 0.5,
    playerRate: 1,
    skipBlankSegment: false,
    showSubtitle: false,
    showSubtitleSpeaker: false,
    playerRecordTime: 0,
    docIsVideo: false,
    videoPlayerHeight: 100,
    subtitlesModel: 'dark',
  }) as any as iDocPlayerData;

export type iDocPlayerDataMap = Record<iDocIDType, iDocPlayerData>;
