import { iDocumentState } from '../../document.type';

import * as docPlayerActions from './docPlayer.actions';

// DocPlayer Reducers
export const docPlayerReducers = {
  // 更新基础播放器数据
  updateDocPlayerDataReducer: (
    state: iDocumentState,
    action: ReturnType<typeof docPlayerActions.updateDocPlayerDataAction>,
  ) => {
    const { docId, data } = action.payload;

    const docPlayerData = data!;
    let _docPlayerData: any = state.docPlayerDataMap;
    // 更新数据
    if (!state.docPlayerDataMap[docId]) {
      // 全局更新
      _docPlayerData = { ..._docPlayerData, [docId]: docPlayerData };
      // state.docPlayerDataMap[docId] = docPlayerData as iDocPlayerData;
    } else {
      // 部分更新
      // eslint-disable-next-line guard-for-in
      for (const key in docPlayerData) {
        const _keyValue = { [key]: docPlayerData[key] };
        _docPlayerData = {
          ..._docPlayerData,
          [docId]: { ..._docPlayerData[docId], ..._keyValue },
        };
      }
    }

    return { ...state, ...{ docPlayerDataMap: _docPlayerData } };
  },
};
