import {
  documentModelNS,
  iDocDataUpdateBasePayload,
} from '../../document.baseType';

import { iDocPlayerData } from '../docPlayer.types';

/** Reducer Actions */
// 初始化播放器数据
export const updateDocPlayerDataAction = (
  payload: iDocDataUpdateBasePayload<Partial<iDocPlayerData>>,
) => ({
  type: 'updateDocPlayerDataReducer',
  payload,
});

/** Effect Actions */
// 初始化播放器数据
export const initDocPlayerDataAction = (
  payload: iDocDataUpdateBasePayload<null>,
) => ({
  type: 'initDocPlayerDataEffect',
  payload,
});

// 更新播放器状态
export const changeDocPlayerStatusAction = (
  payload: iDocDataUpdateBasePayload<
    Partial<
      Pick<
        iDocPlayerData,
        // 基础状态
        | 'playerMode'
        | 'playerCurtTime'
        | 'playerIsPlaying'
        | 'playerMuted'
        | 'playerVolume'
        | 'playerRate'
        // 业务状态
        | 'showSubtitle'
        | 'showSubtitleSpeaker'
        | 'skipBlankSegment'
        // 样式状态
        | 'videoPlayerHeight'
      >
    >
  >,
  // 是否在 Hook 内使用，Hook 内需要加上 NS
  isHookUse = false,
) => ({
  type: `${isHookUse ? `${documentModelNS}/` : ''}updateDocPlayerStatusEffect`,
  payload,
});
