// import type { eBigModelDataType } from '@tingwujs/service';
type eBigModelDataType = any;
import type {
  iBigModelSceneInfo,
  iFeedbackDetail,
  iKeyPointsReview,
  iKeyWordInfo,
} from '../docBigModel.type';
import { eLabInfoStatus, ePPTStatus } from '../docBigModel.type';

/** 服务端返回的大模型数据 */
export interface iDocBigModelDataAPI {
  labCardsMap: Record<
    any,
    Array<iLabInfoStruct<tLabelInfoContent[]> | iLabInfoStructWithPPT>
  >;
}

export enum eLabInfoKey {
  KEY_WORD_INFO = 'keyWordsExtractor', // 关键词信息
  FULL_TEXT_SUMMARY_INFO = 'fullSummary', // 全文概要信息
  CHAPTER_OVERVIEW_INFO = 'titleGenerator', // 章节速览信息
  AGENDA_SUMMARY_INFO = 'agendaSummary', // 议程概要信息
  SPEAK_SUMMARY_INFO = 'roleSummary', // 发言总结信息
  KEY_POINT_REVIEWS_INFO = 'questionAnswerLlm', // 要点回顾信息
  TODO_LIST_INFO = 'actionExtractor', // 待办事项信息
  PPT_TITLE_INFO = 'pptTitle', // PPT标题信息
  PPT__SUMMARY_INFO = 'pptExtractor', // PPT概要信息
  SCENE_INFO = 'scene', // 场景信息
  MIND_MAP_SUMMARY = 'mindMapSummary', // 场景信息
}

interface iBaseContentValue {
  id: number;
  value: string;
}

export interface iKeywordInfoContent {
  type: 'tag';
  contentValues: iKeyWordInfo[];
}

export interface iTitleGeneratorContent {
  type: 'list';
  contentValues: Array<
    iBaseContentValue & {
      summary: string;
      time: number;
      endTime: number;
      extensions: Array<{ sId: number; startTime: number; endTime: number }>;
    }
  >;
}

export interface iFullSummaryContent {
  type: 'list';
  contentValues: iBaseContentValue[];
}

export interface iAgendaSummaryContent {
  type: 'list';
  contentValues: Array<iBaseContentValue & { title: string }>;
}

export interface iRoleSummaryContent {
  type: 'list';
  contentValues: Array<
    iBaseContentValue & {
      speaker: string;
      status: number;
    }
  >;
}

export interface iQuestionAnswerLlmContent {
  type: 'list';
  contentValues: Array<iBaseContentValue & iKeyPointsReview>;
}

export interface iTodoListContent {
  type: 'list';
  contentValues: Array<iBaseContentValue & { time: number }>;
}

export type iPPTTitleContent = iTitleGeneratorContent;

export interface iPPTSummaryContent {
  type: 'list';
  contentValues: Array<{
    id: number; // 🆔标识
    time: number; // 时间戳
    status: number; // 状态
    pictureKey: string; // 高清图像 oss 在线链接
    pictureOssLink: string; // 常规图 oss 在线链接
    pictureThumbnailOssLink: string; // 缩略图 oss 在线链接
    index: number; // 索引标识
    pptSummary?: string; // ppt 概要信息
  }>;
}

export interface iSceneContent {
  type: 'list';
  contentValues: iBigModelSceneInfo[];
}

/** 大模型返回信息基础结构体 */
export interface iLabInfoStruct<T> {
  key: eLabInfoKey;
  basicInfo: { name: string; des: string };
  contents?: T;
  feedbackDetailList?: iFeedbackDetail[];
  status: eLabInfoStatus;
}

export interface iLabInfoStructWithPPT
  extends Omit<iLabInfoStruct<iPPTSummaryContent[]>, 'status'> {
  modelType: 'simple' | 'detail';
  hasPic: boolean;
  status: ePPTStatus;
}

export type tLabelInfoContent =
  | iKeywordInfoContent
  | iFullSummaryContent
  | iRoleSummaryContent
  | iQuestionAnswerLlmContent
  | iTodoListContent
  | iPPTTitleContent
  | iPPTSummaryContent
  | iSceneContent;

/** 内容盒子 */

export type iDiscoveryBigModelDataAPI = {
  [key in eBigModelDataType]: Array<
    iLabInfoStruct<tLabelInfoContent[]> | iLabInfoStructWithPPT
  >;
};
