/**
 *  *************************************************************
 *  ****************  大模型数据 Actions   ***********************
 *  *************************************************************
 */
// *** 文档模型命名空间  ***
import { documentModelNS } from '../../document.baseType';
// *** 类型定义相关 ***

import type {
  Action,
  iDocDataUpdateBasePayload,
} from '../../document.baseType';

import type { iDocBigModelData, iSpeakSummary } from '../docBigModel.type';

const prefix = (path: string, isHookUse = false) => {
  if (!isHookUse) return path;
  return `${documentModelNS}/${path}`;
};

// *** Reducer Actions ***

/**
 * @description: 根据文档🆔更新大模型数据
 */
export const updateDocBigModelDataAction = (
  payload: iDocDataUpdateBasePayload<Partial<iDocBigModelData>>,
  isHookUse = false,
): Action<iDocDataUpdateBasePayload<Partial<iDocBigModelData>>> => ({
  type: prefix('updateBigModelDataReducer', isHookUse),
  payload,
});

/**
 * @description: 替换发言总结概要信息根据发言总结🆔
 */
export const replaceSpeakerSummaryByIdAction = (
  payload: iDocDataUpdateBasePayload<{
    id: number; // 发言总结🆔
    summary: Partial<iSpeakSummary>; // 概要信息
  }>,
  isHookUse = false,
): Action<
  iDocDataUpdateBasePayload<{
    id: number;
    summary: Partial<iSpeakSummary>;
  }>
> => ({
  type: prefix('replaceSpeakerSummaryByIdReducer', isHookUse),
  payload,
});

/**
 * @description: 替换发言总结概要信息根据发言人🆔
 */
export const replaceSpeakerSummaryBySpeakerAction = (
  payload: iDocDataUpdateBasePayload<{
    speaker: string; // 发言人🆔
    summary: Partial<iSpeakSummary>; // 概要信息
  }>,
  isHookUse = false,
): Action<
  iDocDataUpdateBasePayload<{
    speaker: string;
    summary: Partial<iSpeakSummary>;
  }>
> => ({
  type: prefix('replaceSpeakerSummaryBySpeakerReducer', isHookUse),
  payload,
});

/**
 * @description: 清除所有文档的大模型数据
 */
export const clearDocBigModelDataAction = (
  isHookUse = false,
): Action<null> => ({
  type: prefix('clearBigModelDataReducer', isHookUse),
  payload: null,
});

// *** Effect Actions ***

/**
 * @description: 根据文档🆔初始化大模型数据
 */
export const initDocBigModelDataAction = (
  payload: iDocDataUpdateBasePayload,
  isHookUse = false,
) => ({
  type: prefix('initBigModelDataEffect', isHookUse),
  payload,
});

/**
 * @description: 根据文档🆔初始化大模型常规数据
 */
export const initDocBigModelNormalDataAction = (
  payload: iDocDataUpdateBasePayload,
  isHookUse = false,
) => ({
  type: prefix('initBigModelNormalDataEffect', isHookUse),
  payload,
});
