import React from 'react';

import { iDocSpeaker } from '../../../documentModel/docSpeaker/docSpeaker.type';

import {
  editNameSpeakerAvatarList,
  splitedSpeakerAvatarList,
} from '../../../documentModel/docSpeaker/docSpeaker.config';
import './AvatarForSpeaker.less';

// 渲染发言人头像()
const AvatarForSpeaker: React.FC<
  iDocSpeaker & {
    avatarSize?: number;
  }
> = (props) => {
  const {
    speakerAvatar,
    speakerAvatarName,
    speakerAvatarBgColor,
    avatarSize = 24,
    isSpeaking,
    isHighlight,
  } = props;

  // 计算渲染文字大小
  const renderFontSize = Math.floor(avatarSize * (14 / 24));

  // 当前发言人状态
  const renderStateImageSize = Math.floor(avatarSize * (20 / 32));

  /**
   * speakerAvatar undefind 情况下
   * 头像容错处理
   */
  const _speakerAvatar =
    speakerAvatar ||
    (speakerAvatarName
      ? editNameSpeakerAvatarList[0]
      : splitedSpeakerAvatarList[0]);
  if (speakerAvatarName && !speakerAvatar) {
    console.warn(`${speakerAvatarName}:speakerAvatar is undefind`);
  }
  // 渲染：
  // 1. 修改名字的发言人头像(颜色背景、文字)
  // 2. 渲染未修改发言人名称的头像
  return (
    <div className="AvatarForSpeaker">
      <span
        className="AvatarForSpeaker-Photo"
        style={{
          backgroundImage: `url(${_speakerAvatar})`,
          width: `${avatarSize}px`,
          backgroundSize: 'contain',
          display: 'flex',
          height: `${avatarSize}px`,
          alignItems: 'center',
          justifyContent: 'center',
          fontSize: renderFontSize,
          textShadow: speakerAvatarBgColor
            ? `0px 0px 2px ${speakerAvatarBgColor}`
            : '',
        }}
      >
        {!isHighlight && speakerAvatarName && (
          <span className="AvatarForSpeaker-Name">{speakerAvatarName}</span>
        )}
        {isHighlight && (
          <div className="AvatarForSpeaker-State-Highlight">
            <div
              className="AvatarForSpeaker-State-Highlight-Image"
              style={{
                width: `${renderStateImageSize}px`,
                height: `${renderStateImageSize}px`,
              }}
            />
          </div>
        )}
        {isSpeaking && (
          <div
            className={`AvatarForSpeaker-State-Speaking`}
            style={{
              width: `${avatarSize}px`,
              height: `${avatarSize}px`,
            }}
          />
        )}
      </span>
    </div>
  );
};

const memoAvatarForSpeaker = React.memo(AvatarForSpeaker);
export { memoAvatarForSpeaker as AvatarForSpeaker };
