import { pinyin } from 'pinyin-pro';
import React from 'react';

import { Container } from './styled';

const avaImgList = [
  'https://img.alicdn.com/imgextra/i4/O1CN01YWYvdp1c0SNPncPhh_!!6000000003538-2-tps-348-349.png',
  'https://img.alicdn.com/imgextra/i1/O1CN01AQvPYW1T2RYKQjxDp_!!6000000002324-2-tps-339-340.png',
  'https://img.alicdn.com/imgextra/i1/O1CN01IVbqlf1U1ocprZanT_!!6000000002458-2-tps-348-349.png',
  'https://img.alicdn.com/imgextra/i1/O1CN015o7rn41lSEwdaGw3p_!!6000000004817-2-tps-348-349.png',
  'https://img.alicdn.com/imgextra/i4/O1CN01wlHL9o1LPmoRRr1wq_!!6000000001292-2-tps-348-349.png',
  'https://img.alicdn.com/imgextra/i1/O1CN01iVTmPJ28sYrxfQGT3_!!6000000007988-2-tps-348-348.png',
  'https://img.alicdn.com/imgextra/i4/O1CN01mJ8FTD1PMMJONVSa5_!!6000000001826-2-tps-349-349.png',
  'https://img.alicdn.com/imgextra/i1/O1CN01n9SXOp28fHNpq3vKI_!!6000000007959-2-tps-348-349.png',
];

const avaColorList = [
  '#57714B',
  '#C00101',
  '#BE9000',
  '#1F5CA2',
  '#328A71',
  '#514596',
  '#B55899',
  '#C95402',
];

const defavaImgList = [
  'https://img.alicdn.com/imgextra/i1/O1CN01AVOzFA1UV7xvwGrGb_!!6000000002522-2-tps-348-349.png',
  'https://img.alicdn.com/imgextra/i2/O1CN01V5s4Ja1dfxsaBRdCX_!!6000000003764-2-tps-339-340.png',
  'https://img.alicdn.com/imgextra/i4/O1CN01odxoO01xMXOVZ6Pvg_!!6000000006429-2-tps-348-349.png',
  'https://img.alicdn.com/imgextra/i2/O1CN01AwOFQX1jhEfmob7zt_!!6000000004579-2-tps-348-349.png',
  'https://img.alicdn.com/imgextra/i2/O1CN01reRFBM1VhK80fwPqj_!!6000000002684-2-tps-348-349.png',
  'https://img.alicdn.com/imgextra/i3/O1CN01qB4Huw1pi34P50dlV_!!6000000005393-2-tps-348-349.png',
  'https://img.alicdn.com/imgextra/i3/O1CN01CmaoS91T9lshjcAJv_!!6000000002340-2-tps-349-350.png',
  'https://img.alicdn.com/imgextra/i4/O1CN01aa3Wf21hxbb6F8fol_!!6000000004344-2-tps-348-349.png',
];

interface IProps {
  defaultSpeakerStatus?: boolean; // 是否是默认发言人 true 是
  avatarUrl?: string; // 头像
  avaTextOrign: string; // 发言人原始名字
  sizeStyle?: number; // 大小
  nameSizeStyle?: number;
  // realName?: boolean; // 是否为真实修改过的发言人，以便于区分离线的角色分离 eg：角色分离的15，展示15，和手动修改的15，展示1
  nameId?: number; // 替代realName
  // transId?: number | string;
  debug?: string;
}

const AvatarComp: React.FC<IProps> = (props) => {
  const {
    avaTextOrign,
    avatarUrl,
    defaultSpeakerStatus,
    sizeStyle = 24,
    nameSizeStyle,
    nameId,
    // transId,
    debug,
  } = props;

  const calcNameSizeStyle = React.useMemo(() => {
    if (nameSizeStyle) {
      return nameSizeStyle;
    }

    if (sizeStyle === 28) {
      return 16;
    } else {
      return Math.floor(sizeStyle * (18 / 24));
    }
  }, [nameSizeStyle, sizeStyle]);

  const [avaText, setAvaText] = React.useState('');
  const [avaImg, setAvaImg] = React.useState('');
  const [avaColor, setAvaColor] = React.useState('');

  React.useEffect(() => {
    if (avaTextOrign) {
      if (nameId !== undefined) {
        initRealNameImg(avaTextOrign.substr(0, 1), nameId);
      } else {
        initSmartImg(avaTextOrign);
      }
    }
  }, [avaTextOrign, nameId]);

  const initSmartImg = async (avaTextStr: string) => {
    setAvaText(avaTextStr);
    // 输出 对应汉字，不带音调的拼音，且 拼音 ü 替换为 v，且开启姓氏模式，且开启首字母模式
    const avaTextFir = pinyin(avaTextStr, {
      pattern: 'first',
      toneType: 'none',
      v: true,
      mode: 'surname',
    });

    const avaTextBackTemp = avaTextFir.substr(0, 1);
    const avaTextBack = avaTextBackTemp.toUpperCase();
    const str = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    const num = str.indexOf(avaTextBack);
    if (num > -1) {
      backImg(num + 1);
    } else if (isNaN(Number(avaTextStr))) {
      setAvaImg(
        'https://img.alicdn.com/imgextra/i4/O1CN01YWYvdp1c0SNPncPhh_!!6000000003538-2-tps-348-349.png',
      );
      setAvaColor(avaColorList[0]);
    } else {
      backImgByNum(Number(avaTextStr) % 8);
    }
  };

  const initRealNameImg = (avaTextStr: string, imgID: number) => {
    setAvaText(avaTextStr);
    backImgByNum(Number(imgID) % 8);
  };

  const backImg = (imgID: number) => {
    if (imgID < 4) {
      setAvaImg(
        'https://img.alicdn.com/imgextra/i1/O1CN01AQvPYW1T2RYKQjxDp_!!6000000002324-2-tps-339-340.png',
      );
      setAvaColor(avaColorList[1]);
    } else if (imgID < 7) {
      setAvaImg(
        'https://img.alicdn.com/imgextra/i1/O1CN01IVbqlf1U1ocprZanT_!!6000000002458-2-tps-348-349.png',
      );
      setAvaColor(avaColorList[2]);
    } else if (imgID < 10) {
      setAvaImg(
        'https://img.alicdn.com/imgextra/i1/O1CN015o7rn41lSEwdaGw3p_!!6000000004817-2-tps-348-349.png',
      );
      setAvaColor(avaColorList[3]);
    } else if (imgID < 13) {
      setAvaImg(
        'https://img.alicdn.com/imgextra/i4/O1CN01wlHL9o1LPmoRRr1wq_!!6000000001292-2-tps-348-349.png',
      );
      setAvaColor(avaColorList[4]);
    } else if (imgID < 16) {
      setAvaImg(
        'https://img.alicdn.com/imgextra/i1/O1CN01iVTmPJ28sYrxfQGT3_!!6000000007988-2-tps-348-348.png',
      );
      setAvaColor(avaColorList[5]);
    } else if (imgID < 19) {
      setAvaImg(
        'https://img.alicdn.com/imgextra/i4/O1CN01mJ8FTD1PMMJONVSa5_!!6000000001826-2-tps-349-349.png',
      );
      setAvaColor(avaColorList[6]);
    } else if (imgID < 24) {
      setAvaImg(
        'https://img.alicdn.com/imgextra/i1/O1CN01n9SXOp28fHNpq3vKI_!!6000000007959-2-tps-348-349.png',
      );
      setAvaColor(avaColorList[7]);
    } else {
      setAvaImg(
        'https://img.alicdn.com/imgextra/i4/O1CN01YWYvdp1c0SNPncPhh_!!6000000003538-2-tps-348-349.png',
      );
      setAvaColor(avaColorList[0]);
    }
  };
  const backImgByNum = (imgID: number) => {
    if (imgID < avaImgList.length) {
      setAvaImg(
        nameId !== undefined ? avaImgList[imgID] : defavaImgList[imgID],
      );
      setAvaColor(nameId !== undefined ? avaColorList[imgID] : '');
    } else {
      setAvaImg(defavaImgList[0]);
      setAvaColor(avaImgList[0]);
    }
  };

  const defFist =
    'https://img.alicdn.com/imgextra/i2/O1CN01V5s4Ja1dfxsaBRdCX_!!6000000003764-2-tps-339-340.png';

  if (!avatarUrl && !defaultSpeakerStatus) {
    return (
      <Container>
        <span
          className="textPhoto"
          style={{
            backgroundImage: `url(${avaImg || defFist})`,
            width: `${sizeStyle}px`,
            backgroundSize: 'contain',
            display: 'flex',
            height: `${sizeStyle}px`,
            alignItems: 'center',
            justifyContent: 'center',
            fontSize: calcNameSizeStyle,
            textShadow: avaColor ? `0px 0px 2px ${avaColor}` : '',
          }}
        >
          <span className="avaName">
            {nameId !== undefined ? avaText : null}
          </span>
        </span>
      </Container>
    );
  }

  if (avatarUrl) {
    if (debug) {
      console.log(`debug:avatarComp-${debug}-2-0`, JSON.stringify(props));
      console.log(`debug:avatarComp-${debug}-2-1`, avatarUrl);
    }
    return (
      <Container>
        <img
          src={avatarUrl}
          style={{
            borderRadius: `${sizeStyle}px`,
            width: `${sizeStyle}px`,
            height: `${sizeStyle}px`,
          }}
          alt="发言人头像"
        />
      </Container>
    );
  }

  if (defaultSpeakerStatus) {
    if (debug) {
      console.log(`debug:avatarComp-${debug}-3-0`, JSON.stringify(props));
    }
    return (
      <Container>
        <img
          src={
            'https://img.alicdn.com/imgextra/i2/O1CN0116Ium71VLL7pBuRI0_!!6000000002636-2-tps-339-339.png'
          }
          style={{
            borderRadius: `${sizeStyle}px`,
            width: `${sizeStyle}px`,
            height: `${sizeStyle}px`,
          }}
          alt="发言人默认头像"
        />
      </Container>
    );
  }

  if (debug) {
    console.log(`debug:avatarComp-${debug}-4-0`, JSON.stringify(props));
  }
  return (
    <Container>
      <img
        src={''}
        style={{
          borderRadius: `${sizeStyle}px`,
          width: `${sizeStyle}px`,
          height: `${sizeStyle}px`,
        }}
        alt="发言人默认头像"
      />
    </Container>
  );
};
export default AvatarComp;

export const randomNum = () => {
  return Math.floor(Math.random() * 8);
};

export const getDefultAvatarId = async (avaTextOrign: string) => {
  const avaTextStr = avaTextOrign.substr(0, 1);
  const avaTextFir = pinyin(avaTextStr, {
    pattern: 'first',
    toneType: 'none',
    v: true,
    mode: 'surname',
  });

  const avaTextBackTemp = avaTextFir.substr(0, 1);
  const avaTextBack = avaTextBackTemp.toUpperCase();

  const str = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
  const imgID = str.indexOf(avaTextBack);

  if (imgID < 0 && !isNaN(Number(avaTextStr))) {
    return Number(avaTextBack);
  }

  if (imgID < 0 && isNaN(Number(avaTextStr))) {
    return 1;
  }

  if (imgID < 4) {
    return 1;
  } else if (imgID < 7) {
    return 2;
  } else if (imgID < 10) {
    return 3;
  } else if (imgID < 13) {
    return 4;
  } else if (imgID < 16) {
    return 5;
  } else if (imgID < 19) {
    return 6;
  } else if (imgID < 24) {
    return 7;
  } else {
    return 8;
  }
};
