import type { IApi } from 'father';
import { transform } from '@svgr/core';
import jsxPlugin from '@svgr/plugin-jsx';

export default (api: IApi) => {
  api.modifyConfig((memo) => {
    // 修改 father 配置
    return memo;
  });
  // @ts-ignore
  api.addJSTransformer(() => {
    return {
      test: /\.svg$/, // 拦截 .svg 文件
      async transform(content, filePath) {
        const code = await transform(
          content,
          {
            plugins: [jsxPlugin],
            icon: false,
            dimensions: true,
            expandProps: 'end',
            svgo: true,
            titleProp: true,
          },
          { filePath },
        );

        return { code };
      },
    };
  });
};
