import { defineConfig } from 'father';
import { resolve } from 'path';

export default defineConfig({
  // more father config: https://github.com/umijs/father/blob/master/docs/config.md
  esm: {
    output: 'dist',
    transformer: 'babel',
  },
  // umd: {
  //   output: 'umd',
  //   name: 'TingwuDetail',
  //   externals: {
  //     react: 'React',
  //     'react-dom': 'ReactDOM',
  //   },
  // },
  alias: {
    '@@': resolve(__dirname, './src/'),
    '@doc': resolve(__dirname, './src/pages/docASR'),
  },
  plugins: ['./config/plugin.ts'],
  extraBabelPlugins: [['babel-plugin-inline-import', { extensions: ['.svg'] }]],
});
