export interface PresentationAgenda {
  id: string;
  agendaHeading: string;
  beginTime: number;
  endTime: number;
}

export interface Presentation {
  id: string;
  photo: string;
  beginTime: number;
  endTime?: number;
  content?: string;
  isFailed?: boolean;
  isLoadingContent?: boolean;
  isTextTooShort?: boolean;
  photoThumbnail: string;
}

export interface PresentationSummaryStates {
  agendas: PresentationAgenda[];
  ppts: Presentation[];
  agendaPPTMap: Record<
    string,
    {
      ppts: Presentation[];
    }
  >;
}

export const getPresentationSummaryInitState = (): PresentationSummaryStates => {
  return {
    agendas: [],
    ppts: [],
    agendaPPTMap: {},
  };
};
