import { SID } from "@tingwujs/core";
import { SphereContext, SphereController } from "../../base";
import { QnAStates, getQnAInitState, QnaOriginData } from "../qna/qnaState";

export interface AssistantEventesData {
  time?: number | null;
}

export interface AssistantEventes {
  userChangeActive: AssistantEventesData;
  qnaListChange: {
    state: QnAStates;
  };
}
/**
 * question 问题回顾
 * questionAndanswer 问答回顾
 * mainPoint 要点回顾
 */
export type AssistantModelType = "mainPoint" | "";
export enum AssistantModel {
  mainPoin = "mainPoint",
}

export enum AssistantActiveType {
  originActive = 1,
}

export class AiAssistantController extends SphereController<QnAStates, AssistantEventes> {
  key = "assistant";

  originData: QnaOriginData | undefined;
  curReviewtime?: number | null;
  isReview?: boolean;
  forceDisplay?: boolean | null;
  watchSids: SID[] = [];
  model: AssistantModelType | "";

  constructor(context: SphereContext, model?: AssistantModelType) {
    super(context, getQnAInitState());
    this.listen();
    this.model = model || "";
    this.isReview = false;
  }

  // 挂载
  listen() {
    const { tingwuController } = this.context;
    tingwuController.on("paragraphListChange", this.handleparagraphChange);
  }

  // 卸载
  unlisten() {
    const { tingwuController } = this.context;
    tingwuController.off("paragraphListChange", this.handleparagraphChange);
  }

  handleparagraphChange = () => {};

  updateReviewTimeValue(time: number, forceDisplay?: boolean) {
    this.curReviewtime = time;
    this.forceDisplay = forceDisplay;
  }

  setReviewTime(time: number, forceDisplay?: boolean) {
    this.curReviewtime = time;
    this.forceDisplay = forceDisplay;
    if (this.context.tingwuController.getIsEnablePlayingVoice()) {
      this.context.tingwuController.endPlayingVoiceWord();
    }

    this.context.tingwuController.setPlayingVoiceWordByTime(time, forceDisplay);
    this.emit("userChangeActive", {
      time,
    });
  }

  // 回溯点击时，变为播放状态
  setTranslateMode() {
    this.context.tingwuController.startPlayingVoiceWord();
    this.closeReview();
  }

  // 关闭回溯
  closeReview() {
    this.curReviewtime = null;
    this.emit("userChangeActive", {
      time: this.curReviewtime,
    });
  }
}
