import React, { memo, useMemo } from "react";
import { Text } from "./styled";

export interface SummaryErrorTextProps {
  isEmpty?: boolean;
  isFail?: boolean;
  text?: string;
}

export const SummaryErrorText: React.FC<SummaryErrorTextProps> = memo(props => {
  const { isEmpty, isFail, text } = props;
  const renderedText = useMemo(() => {
    if (text) {
      return text;
    }
    if (isFail) {
      return "抱歉，服务器繁忙，任务失败";
    }
    if (isEmpty) {
      return "没有总结内容哦";
    }
  }, [text, isEmpty, isFail]);

  if (!renderedText) {
    return null;
  }
  return <Text>{renderedText}</Text>;
});
