import React, { memo, useEffect, useRef, useState } from "react";
import { Wrapper } from "./styled";

export const SummaryAnimation: React.FC<React.PropsWithChildren<{}>> = memo(props => {
  const { children } = props;

  const [animated, setAnimated] = useState(false);
  const [done, setDone] = useState(false);

  const animatedRef = useRef(animated);
  animatedRef.current = animated;

  useEffect(() => {
    if (animatedRef.current) {
      return;
    }
    if (children) {
      setAnimated(true);
      setTimeout(() => {
        setDone(true);
      }, 1000);
    }
  }, [children]);

  return (
    <Wrapper animated={animated} done={done}>
      {children}
    </Wrapper>
  );
});
