import styled from "styled-components";

export const Wrapper = styled.div`
  .sphereCard-headingOperates {
    visibility: hidden;
  }
  &:hover .sphereCard-headingOperates {
    visibility: visible;
  }
`;

export const Heading = styled.div`
  display: flex;
  justify-content: space-between;
  align-items: center;
  margin-bottom: 12px;
`;

export const Title = styled.div`
  font-size: 14px;
  color: #27264d;
  height: 26px;
  line-height: 24px;
  -webkit-font-smoothing: antialiased;
  font-weight: 600;
  cursor: default;
  display: flex;
  align-items: center;
  user-select: none;

  & > .tingwu-icon {
    color: #605ce5;
    margin-right: 8px;
  }
`;

export const HeadingExtraContainer = styled.div`
  display: flex;
  align-items: center;
`;

export const HeadingOperates = styled.span`
  display: inline-flex;
  align-items: center;
  gap: 14px;

  .icon-item {
    color: #474667;
    cursor: pointer;
    &:hover {
      color: #605ce5;
    }
  }
`;
