import React, { memo } from "react";
import { message, Tooltip } from "@tingwujs/design";
import copy from "copy-to-clipboard";
import { CopyIcon } from "./copyIcon";

export interface CopyOperateProps {
  getCopyText: () => string;
}

export const CopyOperate: React.FC<CopyOperateProps> = memo(props => {
  const { getCopyText } = props;
  return (
    <Tooltip title="复制" overlayClassName="tingwu2-tips" color="rgb(39, 38, 77)">
      <CopyIcon
        className="icon-item"
        onClick={() => {
          copy(getCopyText());
          message.success("复制成功");
        }}
      />
    </Tooltip>
  );
});
