import styled, { css } from "styled-components";

export const Wrapper = styled.div<{
  expanded: boolean;
}>`
  user-select: none;
  font-size: 12px;
  color: rgba(39, 38, 77, 0.65);
  display: flex;
  align-items: center;
  cursor: pointer;
  &:hover {
    color: #605ce5;
  }
  .tingwu-icon {
    margin-left: 2px;
    ${props =>
      props.expanded &&
      css`
        transform: rotate(180deg);
      `}
  }
`;

export const Text = styled.div`
  position: relative;
`;

export const RedDot = styled.div`
  width: 9px;
  height: 9px;
  border-radius: 9px;
  background-color: rgb(255, 128, 128);
  position: absolute;
  top: 0;
  right: -5px;
  border: 1px solid rgb(255, 255, 255);
`;
