import styled, { css } from "styled-components";

export const Wrapper = styled.div`
  display: flex;
  padding: 12px 24px 12px 10px;
  background-color: rgba(96, 92, 229, 0.05);
  border-radius: 8px;

  margin-top: 8px;
  &:first-child {
    margin-top: 0;
  }
`;

export const Heading = styled.div`
  display: flex;
  flex-direction: column;
  align-items: center;
  width: 65px;
  min-width: 65px;
  padding-top: 4px;
  margin-right: 10px;

  > * {
    user-select: none;
  }
`;

export const AvatarContainer = styled.div`
  width: 28px;
  height: 28px;
  margin-bottom: 2px;

  *:first-child {
    width: 100%;
    height: 100%;
    border-radius: 50%;
  }
`;

export const SpeakerName = styled.span`
  display: inline-block;
  width: 100%;
  font-size: 12px;
  line-height: 20px;
  color: rgba(39, 38, 77, 0.65);

  text-align: center;
  overflow: hidden;
  text-overflow: ellipsis;
  white-space: nowrap;

  .ant-tooltip {
    padding-top: 2px;

    .ant-tooltip-inner {
      padding: 4px 8px;
    }
  }
`;

export const ContentContainer = styled.div`
  display: flex;
  align-items: center;
  @keyframes innerAnimation {
    0% {
      opacity: 1;
    }

    30% {
      opacity: 1;
    }
    100% {
      opacity: 0;
    }
  }
  .opacityAnimation {
    animation: innerAnimation 0.5s ease-out;
    opacity: 0;
  }
  .opacity {
    opacity: 0;
  }
`;

export const Content = styled.div<{ expanded: boolean }>`
  font-size: 12px;
  line-height: 20px;
  color: var(--Text_Primary);

  ${({ expanded }) =>
    expanded
      ? css``
      : css`
          /* webkit browser */
          display: -webkit-box;
          -webkit-box-orient: vertical;

          /* Firefox */
          display: -moz-box;
          -moz-box-orient: vertical;

          /* W3C */
          display: box;
          box-orient: vertical;

          -webkit-line-clamp: 3;
          overflow: hidden;
          text-overflow: ellipsis;
        `}
`;

export const DefaultAvatar = styled.div`
  background: url("https://img.alicdn.com/imgextra/i3/O1CN01mqaz5k1gzbSjkrFAW_!!6000000004213-2-tps-339-339.png");
  background-position: center 0;
  background-size: cover;
`;
