import { OperateGesture } from "./gesture";

interface IOperObj {
  result: any;
  maxScale: number;
  minScale: number;
  x: number;
  y: number;
  scale: number;
  image: any;
}

interface IConstVar {
  slideWidth: number;
  slideHeight: number;
  slideTop: number;
  slideLeft: number;
}
const constVar = (): IConstVar => {
  // const ele = document.querySelector('#WrapOperImg');
  const box_ele = document.querySelector(".WrapOperImgBox");
  // const getRectData: any = ele && ele.getClientRects()[0];
  const getBoxData: any = box_ele && box_ele.getClientRects()[0];
  return {
    slideWidth: getBoxData.width,
    slideHeight: getBoxData.height,
    slideTop: getBoxData.top,
    slideLeft: getBoxData.left,
  };
};

// let initScale = 1; // 图片宽高初始比例控制

export const initVar = (val: any) => {
  // initScale = val.initScale;
  initOperObj.scale = val.initScale;
};

export const initImgPos = {
  x: 0,
  y: 0,
  scale: 1,
};

export const initInter = (timer: any, setShowTips: Function) => {
  let count = 0;
  timer.current = setInterval(() => {
    if (count === 5) {
      setShowTips(false);
      clearInterval(timer.current);
      count = 0;
      return;
    }
    count++;
  }, 1000);
};

export const doStyle = (transition: string, type?: string) => {
  if (type === "reset") {
    Object.assign(operObj, initImgPos);
  }
  operObj.image.style.transition = transition;
  operObj.image.style.transform = `translate3d(${operObj.x}px, ${operObj.y}px, 0px) scale(${operObj.scale})`;
};

export const initOperObj: IOperObj = {
  result: null,
  maxScale: 0,
  minScale: 0.1,
  x: 0,
  y: 0,
  scale: 1,
  image: null,
};

// 全局变量
export const operObj: IOperObj = JSON.parse(JSON.stringify(initOperObj));

// 获取放大缩小 比例
export const maxMinScale = () => {
  let in_leftVal = (operObj.scale / 5) * 60;
  if (operObj.scale === 0.1) {
    in_leftVal = -1;
  }
  return in_leftVal;
};

export const doNumInt = (num: number) => Math.round(num * 100);

export const initGesture = (
  boxRef: any,
  timer: any,
  setScaleLeft: any,
  setShowTips: any,
  setPercent: any,
  setShowImg: any,
  nInitLeft: any
) => {
  const useInitData = constVar();
  const gesture = new OperateGesture(boxRef.current, {
    drag(e: any) {
      setShowTips(true);
      operObj.x += e.diffX;
      operObj.y += e.diffY;
      doStyle("none");
    },
    wheel(e: any) {
      const cont_ele: any = document.querySelector(".contentOper");
      cont_ele && (cont_ele.style.overflow = "hidden");
      clearInterval(timer.current);
      const scale = operObj.scale * e.in_scale;
      if (scale > operObj.maxScale) {
        e.in_scale = operObj.maxScale / operObj.scale;
        operObj.scale = operObj.maxScale;
      } else if (scale < operObj.minScale) {
        e.in_scale = operObj.minScale / operObj.scale;
        operObj.scale = operObj.minScale;
      } else {
        operObj.scale = scale;
      }
      const leftVal = maxMinScale();
      setPercent(doNumInt(operObj.scale));
      nInitLeft.current = leftVal;
      setScaleLeft(leftVal);
      const origin = {
        x: (e.in_scale - 1) * operObj.result.width * 0.5,
        y: (e.in_scale - 1) * operObj.result.height * 0.5,
      };

      // 以鼠标位置为中心，计算缩放偏移量
      operObj.x -= (e.in_scale - 1) * (e.clientX - useInitData.slideLeft - operObj.x) - origin.x;
      operObj.y -= (e.in_scale - 1) * (e.clientY - useInitData.slideTop - operObj.y) - origin.y;
      doStyle("none");
      initInter(timer, setShowTips);
      e.preventDefault();
      cont_ele && (cont_ele.style.overflow = "auto");
    },
  });

  // 图片初始信息
  if (!operObj.result) {
    operObj.result = gesture.getImgSize(
      operObj.image.naturalWidth,
      operObj.image.naturalHeight,
      useInitData.slideWidth,
      useInitData.slideHeight
    );
  }
  operObj.image.style.width = `${operObj.result.width}px`;
  operObj.image.style.height = `${operObj.result.height}px`;
  operObj.x = (useInitData.slideWidth - operObj.result.width) * 0.5;
  operObj.y = (useInitData.slideHeight - operObj.result.height) * 0.5;
  initImgPos.x = operObj.x;
  initImgPos.y = operObj.y;
  doStyle("none");
  operObj.maxScale = Math.max(Math.round(operObj.image.naturalWidth / operObj.result.width), 5);
  setShowImg(true);

  return gesture;
};
