import styled, { keyframes } from "styled-components";

export const MultiEllipsisContainer = styled.div`
  position: relative;
  display: flex;
`;

export const Content = styled.div<{
  expand: boolean;
  expandHeight: string;
  lineHeight: number;
  rows?: number;
}>`
  height: ${({ expand, expandHeight, lineHeight, rows }) =>
    rows && !expand ? `${rows * lineHeight}px` : expandHeight};
  font-size: 14px;
  line-height: ${({ lineHeight }) => `${lineHeight}px`};
  overflow: hidden;
  text-align: justify;
  color: #474667;

  &::before {
    content: "";
    float: right;
    height: ${({ expand, expandHeight }) => (!expand ? "100%" : expandHeight)};
    margin-bottom: ${({ lineHeight }) => `-${lineHeight}px`};
  }

  transition: height 0.3s;
  .multiEllipsis-text {
    font-size: 14px;
    letter-spacing: 0;
    box-sizing: border-box;
    white-space: pre-wrap;
    overflow-wrap: anywhere;
    position: relative;
    z-index: 2;
    color: #27264d;
    cursor: pointer;
    -webkit-font-smoothing: antialiased;
  }
`;

export const ExpendButton = styled.div`
  float: right;
  clear: both;
  position: relative;
  z-index: 5;
`;

export const EllipsisText = styled.span`
  transition: opacity 0.3s;
`;

export const ExpendText = styled.div`
  display: inline-block;
  margin-left: 8px;
  font-size: 12px;
  line-height: 1;
  color: #605ce5;
  cursor: pointer;

  &:hover {
    color: #7470e7;
  }
  &:active {
    color: #5b57ce;
  }
`;

const showDot = keyframes`
  0%, 80% {
    opacity: 0;
  }
  100% {
    opacity: 1;
  }
`;

export const RedDot = styled.div<{ rows: number; lineHeight: number }>`
  position: absolute;
  top: ${({ lineHeight, rows }) => `${(rows - 1) * lineHeight + 3}px`};
  right: -5px;
  width: 9px;
  height: 9px;
  border-radius: 9px;
  border: 1px solid rgb(255, 255, 255);
  background-color: rgb(255, 128, 128);

  animation: ${showDot} 1.2s;
`;
