import styled, { css } from "styled-components";

export const Wrapper = styled.div`
  display: flex;
  align-items: center;
`;

export const TabItem = styled.div`
  padding: 0 16px;
  position: relative;

  &:after {
    content: " ";
    display: block;
    position: absolute;
    background-color: #cdcdd6;
    width: 1px;
    height: 14px;
    bottom: 8px;
    right: 0;
  }

  &:first-child {
    padding-left: 0;
  }

  &:last-child {
    padding-right: 0;
    &:after {
      display: none;
    }
  }
`;

export const TabItemInner = styled.div<{
  active: boolean;
}>`
  position: relative;
  padding: 3px 0;
  display: flex;
  align-items: center;
  cursor: pointer;
  font-size: 14px;
  line-height: 24px;
  color: rgba(39, 38, 77, 0.65);
  transition: all 0.2s;

  .tingwu-icon {
    transition: all 0.2s;
    color: #cdcdd6;
    margin-right: 8px;
  }

  &:after {
    content: " ";
    display: block;
    position: absolute;
    bottom: 0;
    left: 20px;
    right: 20px;
    height: 2px;
    border-radius: 2px;
    background-color: #605ce5;
    transition: all 0.2s;
    opacity: 0;
  }

  ${props =>
    props.active &&
    css`
      color: #27264d;
      .tingwu-icon {
        color: #605ce5;
      }
      &:after {
        opacity: 1;
        left: 0;
        right: 0;
      }
    `}
`;
