import React, { memo } from "react";
import { Icon } from "@tingwujs/meeting-icon";
import { Wrapper, TabItem, TabItemInner } from "./styled";

export interface HeadingTabsProps {
  tabs: Array<{ label: string; value: string }>;
  value: string;
  onChange: (value: string) => void;
}

export const HeadingTabs: React.FC<HeadingTabsProps> = memo(props => {
  const { tabs, value, onChange } = props;
  return (
    <Wrapper>
      {tabs.map(tab => {
        const isActived = tab.value === value;
        return (
          <TabItem key={tab.value}>
            <TabItemInner active={isActived} onClick={() => onChange(tab.value)}>
              <Icon type={"tingwu-AI"} size={20} />
              {tab.label}
            </TabItemInner>
          </TabItem>
        );
      })}
    </Wrapper>
  );
});
