import React, { memo, useState, useEffect } from "react";
// import { ReactComponent as Confirm } from '@/assets/svg/confirm.svg';
import { ConfigProvider } from "antd";
import { Modal, Popover } from "@tingwujs/design";
import { Icon } from "@tingwujs/meeting-icon";
import { TopNavStyle, TopNavDown } from "../styled";
import { getFlexibleTime } from "@tingwujs/common";
import { IImgNum } from "./type";
import { TextHtmlType, copyImgData } from "@tingwujs/util";
// import { getBase64Image } from '@tingwujs/util';
import classnames from "classnames";

interface IProps {
  showData: IImgNum;
  onReviewHandler: Function;
  onExport: Function | undefined;
  onDelete: Function | undefined;
  onCopySuccess: Function | undefined;
  pptDownloadLoading: boolean | undefined;
  canDelete: boolean;
}
export const TopNav = memo((props: IProps) => {
  const [showDown, setShowDown] = useState(false);
  const {
    showData,
    onReviewHandler,
    onExport,
    onDelete,
    onCopySuccess,
    pptDownloadLoading,
    canDelete,
  } = props;

  const handleConfirmDelete = () => {
    if (!canDelete) return;
    Modal.confirm({
      width: 510,
      closable: true,
      title: "确定删除本页PPT吗？",
      content: "删除后将无法恢复",
      okText: "确定删除",
      okButtonProps: { danger: true },
      centered: true,
      cancelText: "再考虑下",
      onOk: () => {
        onDelete && onDelete(showData.id);
      },
    });
  };

  useEffect(() => {
    const ele: any = document.querySelector(".down-file");
    if (!ele) return;
    ele.onmousemove = () => {
      !pptDownloadLoading && setShowDown(false);
    };
  }, [pptDownloadLoading]);

  const copyData = async () => {
    let cont_data: any = showData.content;
    if (Array.isArray(cont_data)) {
      cont_data = cont_data.join("\n");
    }
    let tips = {
      fn: "success",
      str: "复制成功",
    };

    const obj: TextHtmlType[] = [
      { type: "img", value: showData.photo || "" },
      { type: "text", value: cont_data || "" },
    ];

    if (!showData.photo && !showData.content) {
      tips = {
        fn: "warning",
        str: "无数据复制",
      };
    }
    copyImgData(obj, tips, onCopySuccess);
  };
  const goReviewHandler = () => onReviewHandler && onReviewHandler(showData.beginTime);

  const PopoverInner = () => {
    const goDown = (e: any) => {
      setShowDown(true);
      if (pptDownloadLoading) return;
      const { type } = e.target.dataset;
      const obj: any = {
        img: showData.id,
        pdf: "",
      };
      onExport && onExport(obj[type]);
    };
    return (
      <>
        {!showDown ? (
          <TopNavDown>
            <p data-type="img" style={{ marginTop: 0 }} onClick={goDown}>
              导出当前图片
            </p>
            <p data-type="pdf" style={{ marginTop: 0 }} onClick={goDown}>
              导出全部PPT为pdf
            </p>
          </TopNavDown>
        ) : null}
      </>
    );
  };

  return (
    <TopNavStyle>
      <section className="nav-left">
        {`${showData.index + 1}/${showData.total}`}&nbsp;&nbsp;
        {getFlexibleTime(showData.beginTime)}
      </section>
      <section className="nav-right">
        {onDelete ? (
          <span
            className={classnames("delete-img", !canDelete ? "no-down" : "")}
            onClick={handleConfirmDelete}
          >
            <Icon type={"tingwu-del"} size={15} />
          </span>
        ) : null}
        {onCopySuccess ? (
          <span className="copy-data" onClick={copyData}>
            <Icon type={"tingwu-piliang"} size={18} />
          </span>
        ) : null}
        {onExport ? (
          <span className={classnames("down-file", pptDownloadLoading ? "no-down" : "")}>
            <ConfigProvider
              theme={{
                token: {
                  sizePopupArrow: 0,
                },
              }}
            >
              <Popover
                content={PopoverInner}
                placement="bottomRight"
                overlayClassName="downs-files"
                overlayStyle={{ paddingTop: "6px" }}
                overlayInnerStyle={{ padding: 0 }}
              >
                <Icon type={"tingwu-download"} size={15} />
              </Popover>
            </ConfigProvider>
          </span>
        ) : null}
        <section className="goback-look" onClick={goReviewHandler}>
          <span className="goback-look-box">
            <Icon type={"tingwu-review"} size={20} style={{ color: "var(--Text_White)" }} />
            <span>回顾</span>
          </span>
        </section>
      </section>
    </TopNavStyle>
  );
});
