import React, { memo, useEffect, useState } from "react";
import { WrapOper } from "../styled";
import { BottomText } from "./bottomText";
import { middleStatus } from "../untils/middleData";
import { IImgNum } from "./type";
import classnames from "classnames";
import { PictureZoom } from "../../pictureZoom";
// import { ReactComponent as NoPptIcon } from '../../../assets/noPpt.svg';

interface IProps {
  showData: IImgNum;
}

export const ImgBoxArea = memo((props: IProps) => {
  const { photo, content, isLoadingContent, photoThumbnail } = props.showData;
  const [imgSrc, setImgSrc] = useState<string>();
  const [midStatus] = useState<boolean>(middleStatus.noData);
  const baseSrc =
    "https://img.alicdn.com/imgextra/i2/O1CN01nLzZgS1hZKMxsmcEG_!!6000000004291-0-tps-1009-567.jpg";
  useEffect(() => {
    if (photo) {
      const newImg = new Image();
      newImg.src = photo;
      newImg.onload = () => {
        setImgSrc(photo || baseSrc);
      };
    }
    setImgSrc(photoThumbnail || baseSrc);
  }, [photo, photoThumbnail]);

  const NoImg = () => {
    return (
      <>
        {middleStatus.noData ? (
          <div className="no-ppt">
            <img src="https://img.alicdn.com/imgextra/i3/O1CN01Vk6YH81JRUp5QWhR4_!!6000000001025-2-tps-390-390.png" />
            <p>没有PPT哦</p>
          </div>
        ) : null}
      </>
    );
  };

  return (
    <WrapOper>
      <PictureZoom
        imgUrl={imgSrc}
        midStatus={midStatus}
        showRestore
        cls={classnames(middleStatus.noData ? "img-hide" : "")}
      >
        <NoImg />
      </PictureZoom>
      <BottomText text={content} isLoadingConten={isLoadingContent} />
    </WrapOper>
  );
});
