import axios from "axios";

export const isDevelopMent = false;

// 直接从 import.meta.env 获取环境变量（Vite 会在编译时静态替换）
// @ts-ignore - import.meta.env 在 Vite 环境中可用
export const API_KEY = import.meta.env?.REACT_APP_API_KEY || process.env?.REACT_APP_API_KEY || "";
// @ts-ignore - import.meta.env 在 Vite 环境中可用
export const APP_ID = import.meta.env?.REACT_APP_APP_ID || process.env?.REACT_APP_APP_ID || "";
export const websocketUrl = "wss://dashscope.aliyuncs.com/api-ws/v1/inference";

const defaultUrl = "/api/services/aigc/multimodal-generation/generation";

const axiosInstance = axios.create({
  withCredentials: true,
  headers: {
    Authorization: `Bearer ${API_KEY}`,
    "Content-Type": "application/json",
  },
  params: {},
});

export const getResultRequest = (url: string) => {
  return axios
    .create()
    .get(url)
    .then(res => {
      console.log(res);
      return res.data;
    })
    .catch(err => {
      return err;
    });
};
const request = {
  get: (params?: any) => {
    return axiosInstance
      .get(defaultUrl, { params })
      .then(res => {
        return res.data;
      })
      .catch(err => {
        return err;
      });
  },
  post: (data: any, url?: string) => {
    return axiosInstance
      .post(url || defaultUrl, data)
      .then(res => {
        return res.data;
      })
      .catch(err => {
        return err;
      });
  },
};

export default request;
