import request, { getResultRequest, isDevelopMent } from "./request";

export const createTaskAPI = (data: iCreateTaskAPIParamsType) => {
  return request.post({
    model: isDevelopMent ? "pre-tingwu-meeting" : "tingwu-meeting",
    ...data,
  });
};

export const getTokens = () => {
  const url = "/api/tokens";
  return request.post("", url);
};

export const getTaskApi = (dataId: string) => {
  return request.post({
    model: isDevelopMent ? "pre-tingwu-meeting" : "tingwu-meeting",
    input: {
      task: "getTask",
      dataId,
    },
  });
};

export const getTransResult = (transId: string): Promise<any> => {
  const query = {
    model: isDevelopMent ? "pre-tingwu-meeting" : "tingwu-meeting",
    input: {
      task: "getTask",
      dataId: transId,
    },
  };
  return request.post(query);
};

export const getDetailsData = (url: string) => {
  return getResultRequest(url);
};

export interface iCreateTaskAPIInputType {
  task: string; // 'createTask' | 'getTask'
  type: string; // 离线音频，固定传offline，在线转写：固定传realtime
  fileId?: string;
  realtimeSrcTargetChoice?: string; // 中翻英: chinese2English 英翻中: english2Chinese
  format?: string; // 格式
  tag?: string;
  sampleRate?: number; // 采样率：8000、16000
  fileUrl?: string;
  appId?: string;
}

export interface iCreateTaskAPIParamsType {
  input: iCreateTaskAPIInputType;
  parameters?: any;
}

export interface iGetTaskAPIParamsType {
  model: string;
  input: {
    task: string; // 'createTask' | 'getTask'
    dataId: string;
    tag: string;
  };
}
