import styled, { keyframes } from "styled-components";

const loadingCircle = keyframes`
  100% {
    transform: rotate(360deg);
  }
`;

export const IconContainer = styled.span<{ size?: number }>`
  display: inline-flex;
  width: ${({ size }) => (size ? `${size}px` : "16px")};
  height: ${({ size }) => (size ? `${size}px` : "16px")};

  .tingwu-icon-spin {
    animation: ${loadingCircle} 1s infinite linear;
  }
`;

export const IconSvg = styled.svg<{ rotate?: number }>`
  width: 100%;
  height: 100%;
  transform: ${({ rotate }) => `rotate(${rotate}deg)`};
`;

export const IconBarContent = styled.div<{ color: string; rotate?: number }>`
  width: 100%;
  height: 100%;
  display: flex;
  justify-content: center;
  align-items: center;
  border-radius: 100%;
  background-color: ${({ color }) => color};
  transform: ${({ rotate }) => `rotate(${rotate}deg)`};
  font-size: 12px;
  color: white;
`;
