import * as React from 'react';
import { render } from '@testing-library/react';
import { Icon } from '../icon';

// Mock iconfont loading
jest.mock('../iconfont', () => ({
  loadIcon: jest.fn(),
}));

describe('Icon', () => {
  it('should render icon with type', () => {
    const { container } = render(<Icon type="test-icon" />);
    const svg = container.querySelector('svg');
    expect(svg).toBeTruthy();
  });

  it('should apply size prop', () => {
    const { container } = render(<Icon type="test-icon" size={24} />);
    const iconContainer = container.querySelector('.tingwu-icon');
    expect(iconContainer).toBeTruthy();
  });

  it('should apply color prop', () => {
    const { container } = render(<Icon type="test-icon" color="#ff0000" />);
    const svg = container.querySelector('svg');
    expect(svg).toBeTruthy();
  });

  it('should apply spin prop', () => {
    const { container } = render(<Icon type="test-icon" spin />);
    const svg = container.querySelector('svg');
    expect(svg).toBeTruthy();
  });

  it('should apply rotate prop', () => {
    const { container } = render(<Icon type="test-icon" rotate={90} />);
    const svg = container.querySelector('svg');
    expect(svg).toBeTruthy();
  });

  it('should apply className prop', () => {
    const { container } = render(<Icon type="test-icon" className="custom-class" />);
    const iconContainer = container.querySelector('.tingwu-icon');
    expect(iconContainer).toBeTruthy();
  });
});

