// Jest config for tingwu-meeting-icon package
const path = require('path');

const rootConfig = require('../../jest.config.js');

module.exports = {
  ...rootConfig,
  rootDir: path.resolve(__dirname, '../..'),
  testMatch: ['<rootDir>/packages/tingwu-meeting-icon/**/__tests__/**/*.test.{ts,tsx}'],
  setupFilesAfterEnv: ['<rootDir>/jest.setup.js'],
  transform: {
    '^.+\\.(ts|tsx)$': ['ts-jest', {
      tsconfig: {
        jsx: 'react-jsx',
        esModuleInterop: true,
        allowSyntheticDefaultImports: true,
      },
    }],
  },
};

