// *** 三方库 ***
import React, { FC, useEffect, useState } from "react";
import { Flex } from "antd";
import styles from "./index.module.less";
import { Card } from "../Card";

export interface iTranscribingPropsType {
  className?: string;
  style?: React.CSSProperties;
  title?: string;
  description?: string;
}
const Transcribing: FC<iTranscribingPropsType> = props => {
  const {
    className = "",
    style = {},
    title = "智能纪要生成中…",
    description = "正在为您转写录音内容，该过程将在1-3分钟内完成，感谢您的耐心等待。",
  } = props;

  const [visible, setVisible] = useState(false);

  useEffect(() => {
    // 组件挂载后触发opacity动画
    const timer = setTimeout(() => {
      setVisible(true);
    }, 0);

    return () => clearTimeout(timer);
  }, []);

  return (
    <div className={`${styles.Transcribing} ${className}`} style={style}>
      <Flex
        vertical
        gap={8}
        align="center"
        justify="center"
        className={styles.Transcribing__Content}
        style={{ opacity: visible ? 1 : 0 }}
      >
        <div className={styles.Transcribing__Img}>
          <img
            src="https://img.alicdn.com/imgextra/i4/O1CN01tfi15f1bZtOb3wMnO_!!6000000003480-2-tps-2385-680.png"
            alt=""
            className={styles.Transcribing__Img__Content}
          />
          <Card />
        </div>
        <div className={styles.Transcribing__Title}>{title}</div>
        <div className={styles.Transcribing__Description}>{description}</div>
      </Flex>
    </div>
  );
};

const memoWrapper = React.memo(Transcribing);

export { memoWrapper as Transcribing };
