// *** 三方库 ***
import React, { FC, useEffect, useState } from "react";
import { Flex } from "antd";
import styles from "./index.module.less";
import { CheckCircle } from "@tingwujs/components";
import { Card } from "../Card";

export interface iTranscribedSuccessPropsType {
  className?: string;
  style?: React.CSSProperties;
  title?: string;
  description?: string;
}
const TranscribedSuccess: FC<iTranscribedSuccessPropsType> = props => {
  const {
    className = "",
    style = {},
    title = "转写成功",
    description = "马上为您自动跳转至分析结果",
  } = props;

  const [visible, setVisible] = useState(false);

  useEffect(() => {
    // 组件挂载后触发opacity动画
    const timer = setTimeout(() => {
      setVisible(true);
    }, 0);

    return () => clearTimeout(timer);
  }, []);

  return (
    <div className={`${styles.TranscribedSuccess} ${className}`} style={style}>
      <Flex
        vertical
        gap={8}
        align="center"
        justify="center"
        className={styles.TranscribedSuccess__Content}
        style={{ opacity: visible ? 1 : 0 }}
      >
        <div className={styles.TranscribedSuccess__Img}>
          <img
            src="https://img.alicdn.com/imgextra/i4/O1CN01tfi15f1bZtOb3wMnO_!!6000000003480-2-tps-2385-680.png"
            alt=""
            className={styles.TranscribedSuccess__Img__Content}
          />
          <Card />
        </div>
        <div className={styles.TranscribedSuccess__Title}>
          <Flex justify="center" align="center" gap={8}>
            <CheckCircle />
            {title}
          </Flex>
        </div>
        <div className={styles.TranscribedSuccess__Description}>{description}</div>
      </Flex>
    </div>
  );
};

const memoWrapper = React.memo(TranscribedSuccess);

export { memoWrapper as TranscribedSuccess };
