import styled, { keyframes } from "styled-components";

export const TextAnimationContainer: any = styled.div`
  overflow: hidden;
  margin-top: -14px;
  flex: 1;
  .animation-texts {
    display: inline-flex;
    flex-direction: column;
    color: #1366ec;
    width: 100%;
    height: 72px;
    line-height: 72px;
    > div > div {
      display: inline-block;
    }
  }
`;

const textUp: any = keyframes`0% { transform: translateY(0); } 100% { transform: translateY(-100%); }`;

export const Word: any = styled.div<{ wordIndex: number; isSecondLine?: boolean }>`
  animation: 0.3s ease-in-out
    ${({ wordIndex, isSecondLine }) => `${(wordIndex + (isSecondLine ? 2 : 1)) * 0.1 + 3}s`}
    ${textUp};
`;
