export const FailedMapTable = [
  {
    code: "ServerError",
    message: "系统出错了，请重试",
    canRetry: true,
  },
  {
    code: "TSC.AudioFileSize",
    message: "音频文件超出6G限制，请更换体验文件",
    canRetry: false,
  },
  {
    code: "TSC.FileError",
    message: "文件不可被读取，请更换文件后重试",
    canRetry: false,
  },
  {
    code: "TSC.AudioSampleRate",
    message: "不支持该音频采样率，请更换8K/16K/24K/48K采样率的体验文件",
    canRetry: false,
  },
  {
    code: "TSC.AudioDuration",
    message: "音频时长超出6小时限制，请更换体验文件",
    canRetry: false,
  },
  {
    code: "TSC.AudioFormat",
    message: "无效的音频格式，请更换体验文件",
    canRetry: false,
  },
  {
    code: "TSC.FileType",
    message: "无效文件，请更换音视频文件后，再进行体验文件",
    canRetry: false,
  },
  {
    code: "TSC.TextFileIllegal",
    message: "疑似转写内容有安全风险，请替换体验文件",
    canRetry: false,
  },
];

export const expTheme = {
  theme: {
    token: {
      borderRadius: 0,
      borderRadiusLG: 0,
      borderRadiusXL: 0,
    },
  },
};

export const expDetailTheme = {
  theme: {
    components: {
      Slider: {
        railBg: "var(--adc-color-blue-100)",
        railHoverBg: "var(--adc-color-blue-100)",
        trackBg: "var(--adc-color-bg-primary)",
        trackHoverBg: "var(--adc-color-bg-primary)",
        handleColor: "var(--adc-color-bg-primary)",
        handleActiveOutlineColor: "var(--adc-color-bg-primary)",
        handleActiveColor: "var(--adc-color-bg-primary)",
        railSize: 8,
        handleSize: 12,
        handleSizeHover: 12,
      },
    },
  },
};
